package warlock;

import	java.applet.Applet;
import	java.awt.*;
import	java.io.*;
import	java.util.Random;
import	java.util.StringTokenizer;
import	java.util.Vector;

/***
//	This is a basic class that is common to all player and non-player
//  characters in Warlock.
***/

public class Character
{
    int             strength;
    int             intelligence;
    int             wisdom;
    int             constitution;
    int             dexterity;
    int             agility;
    int             charisma;
    int             size;
    int             hits;		// Total hits, adjusted by constitution.
    int             rolledHits;		// Hits rolled for the character, unadjusted.
    int             level;		// Level for the character.
    String          name;		// Actual name or generated name.
    int             characterClass;	// 0 = Fighter, 1 = Cleric, etc.
    int             savingThrowClass;	// Corresponds to Character or Monster ST class.
    static final int elf			= 0;	// Character type for Elves            (Vector/array index).
    static final int fighter			= 1;	// Character type for Fighters         (bit mask *and* Vector index).
    static final int cleric			= 2;	// Character type for Clerics          (bit mask *and* Vector index).
    static final int dwarf			= 3;	// Character type for Dwarves          (Vector/array index).
    static final int mage			= 4;	// Character type for Magic Users      (bit mask *and* Vector index).
    static final int hobbit			= 5;	// Character type for Hobbits          (Vector/array index).
    static final int paladin			= 6;	// Character type for Paladins         (Vector/array index).
    static final int ranger			= 7;	// Character type for Rangers          (Vector/array index).
    static final int thief			= 8;	// Character type for Thieves          (bit mask *and* Vector index).
    static final int magicalFighter		= 9;	// Character type for Magical Fighters (Vector/array index).
    static final int magicalThief		= 10;	// Character type for Magical Thieves           ".
    static final int magicalCleric		= 11;	// Character type for Magical Clerics           ".
    static final int clericalThief		= 12;	// Character type for Clerical Thieves          ".
    static final int clericalFighter		= 13;	// Character type for Clerical Fighters         ".
    static final int fightingThief		= 14;	// Character type for Fighting Thieves          ".
    static final int warriorPriest		= 15;	// Character type for Warrior Priests           ".
    static final int magicalClericalFighter	= 16;	// Character type for Magical Clerical Fighters ".
    static final int magicalClericalThief	= 17;	// Character type for Magical Clerical Thieves  ".
    static final int elvenThief			= 18;	// Character type for Elven Thieves             ".
    static final int dwarvenThief		= 19;	// Character type for Dwarven Thief             ".
    static final int clericalFightingThief	= 20;	// Character type for Clerical Fighting Thieves ".
    static final int cavalier			= 21;	// Character type for Cavalier                  ".
    static int [][] wholeHitDice;	// Hit dice by character class & level.
    static int [][] partialHitDice;	// Fractional (1/3, 1/2, or 2/3) hit dice.
    static int [][] hitDiceLevel;	// Rounded up level based on hit dice.
    static Vector   classNames;		// Names of the various character classes
    
/***
//	The Character class has static information that it reads in from text
//  files.  These are files that can be created by exporting the tables in the
//  rules.  Each table should be tab delimited with each row ending in a <CR>
//  and/or <LF>.
//  <p>
//	If any table in the rules is changed, you merely have to update the file
//  by converting the table to text and exporting the result to the file.  The
//  format should not be changed, with the single exception of the hit dice in
//  the experience tables.  In there you should change the fractional hit dice
//  so that " 1/2" is replaced with ".3", " 1/3" is replaced with ".2", and
//  " 2/3" is replaced with ".4".  These represent both the dice to be rolled
//  and the max value possible for the partial hit die at that point.  A .4 is
//  an indication of a 1/2 or higher die, so level is whole dice + 1 for attack
//  & defense, but for hits you roll a 2-sided die for that level.
//  <p>
//	Note that any changes to character class names in the rules require code
//  changes in the code that parse these files.  These are read in at program
//  initialization, so they must be there!  Note that spaces are preserved!
//  <p>
//	The files expected are as follows:
//	Experience.txt	- Basic experience chart (Fighter, Cleric, Mage, Thief)
//	Heroes.txt	- Experience chart (Cavalier, Paladin, Halfling, Dwarf)
//	Doubles.txt	- Experience chart (Elves, Basic Doubles, Warrior Priest)
//	Triples.txt	- Experience chart (Basic Triples, Ranger, Elven & Dwarven Thief)
//	BeingST.txt	- Being saving throw chart (Player classes)
//	MonsterST.txt	- Monster/Creature saving throw chart
//	CharBasedST.txt	- Characteristic-based saving throw chart
//	Strength.txt	- Strength and carrying capacity chart
***/

static	// Initialize all static values
{
//	StreamTokenizer is another possibility here...

    FileReader      TableFileReader;
    BufferedReader  TableFileBuffer;
    String          TableRow;
    String          Token;
    StringTokenizer RowTokens;
    int             Column;
    int             Row;
    int             WholeDie;
    int             PartialDie;
    Vector          WholeDiceTable;	// This will be a Vector of Vectors to represent the table.
    Vector          PartialDiceTable;	// This will be a Vector of Vectors to represent the table.
    int             Class;
    final String [] ClassNames ={"Elf",				// #0
                                 "Fighter",			// #1
                                 "Cleric",			// #2
                                 "Dwarf",			// #3
                                 "Magic User",			// #4
                                 "Hobbit",			// #5
                                 "Paladin",			// #6
                                 "Ranger",			// #7
                                 "Thief",			// #8
                                 "Magical Fighter",		// #9
                                 "Magical Thief",		// #10
                                 "Magical Cleric",		// #11
                                 "Clerical Thief",		// #12
                                 "Clerical Fighter",		// #13
                                 "Fighting Thief",		// #14
                                 "Warrior Priest",		// #15
                                 "Magical Clerical Fighter",	// #16
                                 "Magical Clerical Thief",	// #17
                                 "Elven Thief",			// #18
                                 "Dwarven Thief",		// #19
                                 "Clerical Fighting Thief",	// #20
                                 "Cavalier"};			// #21
////
//	Populate the initial class names so that the four basic types are binary
//  index values.  This way the index values for the four basic classes are all
//  bit mask values that can be used as flags to determine what abilities and
//  spells each class has.
////
    classNames = new Vector ();		// Names of the various character classes
    for (Row = 0; Row < ClassNames.length; Row ++)
        classNames.addElement (ClassNames [Row]);	// Populate the Vector.
    
    wholeHitDice = new int [classNames.size ()] [];	// Hit dice by character class & level.
    partialHitDice = new int [classNames.size ()] [];	// Fractional (1/3, 1/2, or 2/3) hit dice.
    hitDiceLevel = new int [classNames.size ()] [];	// Rounded up level based on hit dice.
    try
    {	// Read from the file until EOF.
	TableFileReader = new FileReader ("Experience.txt");
	TableFileBuffer = new BufferedReader (TableFileReader);
        Row = 0;
        WholeDiceTable = new Vector ();
        PartialDiceTable = new Vector ();
        
        do
        {	// Read lines from the file.  Each is one row of the table.  EOF is a blank line.
            TableRow = TableFileBuffer.readLine ();
            RowTokens = new StringTokenizer (TableRow, "\t\r\n");
            
            for (Column = 0; RowTokens.hasMoreElements (); Column ++)
            {	// Pull out the column items one at a time and place in static arrays.
                Token = RowTokens.nextToken ();
                if (Row == 0)
                {
                    Class = classNames.indexOf (Token);
                    if (Class == -1
                    || (Column == 0 && !Token.equals ("Level")) 
                    || (Column == 1 && !Token.equals ("Experience")))
                    {
                        System.out.println ("Token '" + Token + "' on line 1, column " + (Column + 1) + " unexpected in " + TableFileReader.toString ());
                        System.exit (-1);
                    }	// if
                    
                    WholeDiceTable.addElement (new Vector ());	// Add a Vector for this column.
                    ((Vector) WholeDiceTable.elementAt (Column)).addElement (new Integer (Class));	// Add the index into classNames for this column.
                    PartialDiceTable.addElement (new Vector ());	// Add a Vector for this column.
                    ((Vector) PartialDiceTable.elementAt (Column)).addElement (new Integer (Class));	// Add the index into classNames for this column.
                }	// if
                else  if (Column > 1)
                {	// Fill in the hit dice table info in the temporary Vector arrays.
                    if (Token.length () > 2 && Token.charAt (Token.length () - 2) == '.')
                    {	// This has a fractional portion to it.
			WholeDie = (new Integer (Token.substring (0, Token.length () - 2))).intValue ();
			PartialDie = (new Integer (Token.substring (Token.length () - 1))).intValue ();
                    }	// if
                    else
                    {	// This is simply a whole die at this level.
                        WholeDie = (new Integer (Token)).intValue ();
                        PartialDie = 0;
                    }	// else
                    
                    ((Vector) WholeDiceTable.elementAt (Column)).addElement (new Integer (WholeDie));
                    ((Vector) PartialDiceTable.elementAt (Column)).addElement (new Integer (PartialDie));
                }	// else-if
            }	// for
        } while (RowTokens.countTokens () != 0);

        TableFileBuffer.close ();	// Close the file.  Normal to get here.
	for (Column = 0; Column < WholeDiceTable.size (); Column ++)
	{   // Now place the info from the Vectors we built into arrays for easy access.
	    Class = ((Integer) WholeDiceTable.elementAt (0)).intValue ();	// The 0th element holds the class index #.
	    wholeHitDice [Class] = new int [((Vector) WholeDiceTable.elementAt (0)).size ()];
	    partialHitDice [Class] = new int [((Vector) WholeDiceTable.elementAt (0)).size ()];
	    hitDiceLevel [Class] = new int [((Vector) WholeDiceTable.elementAt (0)).size ()];
	    
	    for (Row = 0; Row <= ((Vector) WholeDiceTable.elementAt (0)).size (); Row ++)
	    {	// Populate the new array from the Vectors we built up from the file.
		
	    }	// for
	}   // for
    }	// try
    catch (Exception Except)
    {
        Except.printStackTrace ();	// We should not get here.
        System.exit (-1);
    }	//* catch
    
}	// static

/***
//	The default Character constructor rolls a new character with the basic
//  characteristics.  
***/
    public Character ()
    {
        rerollCharacter (this);
    }	// Default constructor

    public static void rerollCharacter (Character Char)
    {
        Char.strength     = Dice.rollDice (3, 6);
        Char.intelligence = Dice.rollDice (3, 6);
        Char.wisdom       = Dice.rollDice (3, 6);
        Char.constitution = Dice.rollDice (3, 6);
        Char.dexterity    = Dice.rollDice (3, 6);
        Char.agility      = Dice.rollDice (3, 6);
        Char.charisma     = Dice.rollDice (3, 6);
        Char.size         = Dice.rollDice (3, 6);
//        SetSavingThrows (Char);
//        SetCapacityAndSpeedClasses (Char);
//        SetModifiers (Char);
    }	// rerollCharacter

    public static void DisplayCharacterInfo (Character Char)
    {
        System.out.println ("strength:     " + Char.strength);
        System.out.println ("intelligence: " + Char.intelligence);
        System.out.println ("wisdom        " + Char.wisdom);
        System.out.println ("constitution: " + Char.constitution);
        System.out.println ("dexterity:    " + Char.dexterity);
        System.out.println ("agility:      " + Char.agility);
        System.out.println ("charisma:     " + Char.charisma);
        System.out.println ("size:         " + Char.size);
        System.out.println ("Name:         " + Char.name);
    }	// DisplayCharacterInfo

    public static void main (String args [])
    {
        Character	NPC = new Character ();

        NPC.name = "NPC test character";
        DisplayCharacterInfo (NPC);
    }	// Main routine for testing Character class
}	// Character class
